//
//  MCSLEConfigViewProtocol.h
//  MCApplication
//
//  Created by Michael Clark on 15/02/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import "MCSLEConfigViewProtocol.h"

#import <MCFoundation/MCSourceList.h>
#import <MCFoundation/MCSourceListDefines.h>


@protocol MCSLEConfigViewProtocol <NSObject>

- (void)configure;

- (MCSourceListType)sourceListType;
- (void)setSourceListType:(MCSourceListType)aSourceListType;

// The config view can read the queryDisplayState and displayState from the source list and configure themselves to show the representation that makes sense based on this information
- (id <MCSourceList>)sourceList;
- (void)setSourceList: (id <MCSourceList>)aSourceList;

- (NSString*)entityName;
- (void)setEntityName: (NSString*)entityName;

// returns 'App' if no identifier is set.
- (NSString*)queryCriteriaSubsetIdentifier;
- (void)setQueryCriteriaSubsetIdentifier: (NSString*)aIdent;


// These methods return the current state that is being represented visually by the config view
- (NSDictionary*)queryDisplayState;
- (NSDictionary*)displayState;


- (BOOL)needsSmartCheckBox;
- (BOOL)isSmart;
- (void)setIsSmart: (BOOL)aFlag;


@end
